import { Link, useLocation } from 'react-router-dom'
import { BookOpen, Facebook, Instagram, Twitter, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="header-content">
          <div className="logo">
            <BookOpen className="logo-icon" size={28} />
            <span>Библиотека</span>
          </div>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              Мои заказы
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              Забронировать
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <BookOpen className="footer-logo-icon" size={32} />
              <h2>Библиотека</h2>
            </div>
            <p className="footer-description">
              Современная библиотека с богатой коллекцией книг. 
              Мы предоставляем доступ к знаниям уже более 50 лет.
            </p>
            <div className="social-links">
              <a href="#" className="social-link" aria-label="Facebook">
                <Facebook className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Instagram">
                <Instagram className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Twitter">
                <Twitter className="social-icon" size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><Link to="/book">Забронировать книгу</Link></li>
              <li><a href="#">Художественная литература</a></li>
              <li><a href="#">Научные издания</a></li>
              <li><a href="#">Учебные материалы</a></li>
              <li><a href="#">Детская литература</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Информация</h3>
            <ul className="footer-links">
              <li><a href="#">О библиотеке</a></li>
              <li><a href="#">Новости</a></li>
              <li><a href="#">События</a></li>
              <li><a href="#">Правила пользования</a></li>
              <li><a href="#">Вакансии</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <div className="footer-contact">
              <div className="contact-item">
                <Phone className="contact-icon" size={18} />
                <span>+7 (495) 123-45-67</span>
              </div>
              <div className="contact-item">
                <Mail className="contact-icon" size={18} />
                <span>info@library.ru</span>
              </div>
              <div className="contact-item">
                <MapPin className="contact-icon" size={18} />
                <span>г. Москва, ул. Книжная, д. 15</span>
              </div>
              <div className="contact-item">
                <Clock className="contact-icon" size={18} />
                <span>Пн-Сб: 9:00 - 20:00, Вс: 10:00 - 18:00</span>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Библиотека. Все права защищены.</p>
          <div className="footer-legal">
            <a href="#">Политика конфиденциальности</a>
            <span>|</span>
            <a href="#">Условия использования</a>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

